# Video Audio Amplifier - Feature List

A running checklist of features for the Video Audio Amplifier tool.  
Edit this file as development progresses. Mark completed items with `[x]`.  
Upload this file before starting a new coding round.

---

## 1. Core Functions
- [ ] Open video file (MP4, MOV, etc.)
- [ ] Extract audio track from video
- [ ] Apply user-specified gain (in dB)
- [ ] Save amplified audio back into video or as separate audio file
- [ ] Default output filename with suffix (e.g. `_10db.mp4`)

---

## 2. File Handling
- [ ] Remember last opened video file
- [ ] Allow choosing output folder
- [ ] Allow user to edit output filename and suffix
- [ ] Ask before overwriting if output file exists
- [ ] Option to replace original file

---

## 3. Gain Control
- [ ] User entry for gain in dB (supports positive/negative, fractions allowed)
- [ ] Default gain value (e.g. `+10dB`)
- [ ] Optional preset buttons for common gain levels (e.g. +5, +10, +15)
- [ ] Display resulting estimated peak/volume level (optional)

---

## 4. GUI
- [ ] Tkinter-based interface
- [ ] Browse button for selecting video
- [ ] Numeric entry for gain
- [ ] Entry for custom output suffix
- [ ] Drag-and-drop support for video files
- [ ] Confirmation dialog after processing showing output path

---

## 5. Advanced Features (Future Ideas)
- [ ] Batch amplify multiple video files at once
- [ ] Preview audio before saving
- [ ] Normalize audio automatically
- [ ] Visual waveform display of audio levels
- [ ] Save preset configurations for repeated use

---

## Notes
- Use standard Python libraries: `tkinter`, `moviepy` or `pydub` for audio processing
- Keep code modular so GUI and audio-processing logic can be reused
- Store user preferences (last folder, last gain, last suffix) in JSON config
